#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_TimeZone : BaseTest 
	{
		private const char TestTimeZoneID = 'A';
		private const char NonExistentTimeZoneID = 'J';

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		//TODO: Empty Constructor can be removed in DAL.TimeZone - unused.

		[Test]
		public void GetAll_Pass()
		{
			DataTable dtTest = DAL.TimeZone.GetAll();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.TimeZoneId), TABLES.TimeZone.TimeZoneId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.TimeZoneName), TABLES.TimeZone.TimeZoneName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.StandardTimeText), TABLES.TimeZone.StandardTimeText);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod ) ]
		public void GetAll_Fail() 
		{
		}

		[Test]
		public void GetByID_Pass()
		{
			Assert.AreEqual( 
				TestTimeZoneID, 
				Convert.ToChar( DAL.TimeZone.GetByID( TestTimeZoneID )[ TABLES.TimeZone.TimeZoneId ] ) );
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetByID_Fail()
		{
			DAL.TimeZone.GetByID( NonExistentTimeZoneID );
		}
	}
}
#endif
